
(* 4x3 flyways 4 xbots - HoldForPMCState, HoldForXbot(s)Idle, HoldForXbot(s)State *)
FUNCTION_BLOCK Example23_holdfor
	(*reboot PMC*)
	PMC_Reboot1(PM_Controller := PM_Controller,Execute := Execute);

	(*hold until PMC is done rebooting and is inactive*)
	PMC_HoldForPMCState1(PM_Controller := PM_Controller,Execute := PMC_Reboot1.Ack,State := 1);

	Delay1(Execute := PMC_HoldForPMCState1.Done,Cycles := 5000);

	(*activate xbots*)
	PMC_ActivateXbots1(PM_Controller := PM_Controller,Execute := Delay1.Done);

	(*hold until xbot 4 is idle*)
	PMC_HoldForXbotIdle1(PM_Controller := PM_Controller,Execute := PMC_ActivateXbots1.Ack,XbotID := 4);

	(*move all xbots to bottom of flyways*)
	xbotID_array78[0] := 1;xbotID_array78[1] := 2;xbotID_array78[2] := 3;xbotID_array78[3] := 4;
	posX_array78[0] := 0.06;posX_array78[1] := 0.3;posX_array78[2] := 0.54;posX_array78[3] := 0.78;
	posY_array78[0] := 0.06;posY_array78[1] := 0.06;posY_array78[2] := 0.06;posY_array78[3] := 0.06;
	PMC_AutoDrivingMotionVelocity1(PM_Controller := PM_Controller,Execute := PMC_HoldForXbotIdle1.Done,nXbots := 4,RoutingType := 0,ZoneID := 0,XbotID := xbotID_array78,PosX := posX_array78,PosY := posY_array78,MaxVel := 1,MaxAcc := 10);

	(*hold until xbot 2 is idle*)
	PMC_HoldForXbotState1(PM_Controller := PM_Controller,Execute := PMC_AutoDrivingMotionVelocity1.Ack,XbotID := 2,State := 3);

	(*move all xbots to the bottom of flyways at different speeds*)
	PMC_XYMotion1(PM_Controller := PM_Controller,Execute := PMC_HoldForXbotState1.Done,cmdLB := 7,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.06,PosY := 0.66,EndVel := 0,MaxVel := 1,MaxAcc := 10);
	PMC_XYMotion2(PM_Controller := PM_Controller,Execute := PMC_XYMotion1.Ack,cmdLB := 8,XbotID := 2,Mode := 0,Type_ := 0,PosX := 0.3,PosY := 0.66,EndVel := 0,MaxVel := 2,MaxAcc := 20);
	PMC_XYMotion3(PM_Controller := PM_Controller,Execute := PMC_XYMotion2.Ack,cmdLB := 9,XbotID := 3,Mode := 0,Type_ := 0,PosX := 0.54,PosY := 0.66,EndVel := 0,MaxVel := 0.5,MaxAcc := 5);
	PMC_XYMotion4(PM_Controller := PM_Controller,Execute := PMC_XYMotion3.Ack,cmdLB := 10,XbotID := 4,Mode := 0,Type_ := 0,PosX := 0.78,PosY := 0.66,EndVel := 0,MaxVel := 2,MaxAcc := 0.1);

	(*hold until all xbots are idle*)
	xbotID_array78[0] := 1;xbotID_array78[1] := 2;xbotID_array78[2] := 3;xbotID_array78[3] := 4;
	PMC_HoldForXbotsIdle1(PM_Controller := PM_Controller,Execute := PMC_XYMotion4.Ack,nXbots := 4,XbotID := xbotID_array78);

	(*move xbot 1 to bottom of flyway, land xbot 4*)
	PMC_XYMotion5(PM_Controller := PM_Controller,Execute := PMC_HoldForXbotsIdle1.Done,cmdLB := 12,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.06,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);
	PMC_LevitationCtrl1(PM_Controller := PM_Controller,Execute := PMC_XYMotion5.Ack,XbotID := 4,Level := 0,Speed := 0,LandedZForce := 0);

	(*hold until xbot 4 is landed and all other xbots are idle*)
	xbotID_array78[0] := 1;xbotID_array78[1] := 2;xbotID_array78[2] := 3;xbotID_array78[3] := 4;
	state_array78[0] := 3;state_array78[1] := 3;state_array78[2] := 3;state_array78[3] := 2;
	PMC_HoldForXbotsState1(PM_Controller := PM_Controller,Execute := PMC_LevitationCtrl1.Ack,nXbots := 4,XbotID := xbotID_array78,States := state_array78);

	Done := PMC_HoldForXbotsState1.Done;
END_FUNCTION_BLOCK
